/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPHumanAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.vo.HumanKihonCardVo;

public class HumanKihonCardAction extends MosPHumanAction {

	// R}h
	public  static final String CMD_HUMAN_BASIS_SHOW      = "H1020";
	private static final String CMD_HUMAN_BASIS_SELECT    = "H1021";
	private static final String CMD_HUMAN_BASIS_INSERT    = "H1022";
	private static final String CMD_HUMAN_BASIS_UPDATE    = "H1023";

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		// VO̎擾
		HumanKihonCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_HUMAN_BASIS_SHOW)) {
			// \(VK)
			show(vo);
		} else if (cmd.equals(CMD_HUMAN_BASIS_SELECT)) {
			// \(ЈR[hŏ)
			select(vo);
		} else if (cmd.equals(CMD_HUMAN_BASIS_INSERT)) {
			// o^
			insert(vo);
		} else if (cmd.equals(CMD_HUMAN_BASIS_UPDATE)) {
			// XV
			update(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected HumanKihonCardVo getInitVo() {
		HumanKihonCardVo vo = (HumanKihonCardVo)getStoredVo(CommonConst.VO_HUMAN_KIHON);
		if (vo == null) {
			vo = new HumanKihonCardVo();
		}
		return vo;
	}

	/**
	 * 
	 * @param vo	ΏVO
	 */
	protected void init(HumanKihonCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_HUMAN_KIHON, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// p[^擾
		vo.setParams(request);
		// {^eݒ
		setListButton(vo);
		// v_Eݒ
		setPulldown(vo);
	}

	/**
	 * VKo^ʕ\
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void show(HumanKihonCardVo vo) throws Exception {
		// [hݒ
		vo.setMode(HumanKihonCardVo.MODE_INSERT);
		// IЈR[h擾
		String kCode = vo.getTxtChangeKCode();
		// VO
		vo.initFields();
		vo.setTxtKCode(kCode);
		Date date = util.getSystemDate();
		vo.setPltEntranceYear (String.valueOf(MospUtility.getYear	(date)));
		vo.setPltEntranceMonth(String.valueOf(MospUtility.getMonth	(date)));
		vo.setPltEntranceDay  (String.valueOf(MospUtility.getDay	(date)));
	}

	/**
	 * f[^\
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void select(HumanKihonCardVo vo) throws Exception {
		// \(ЈR[hŏ)
		// IЈR[h擾
		String kCode = "";
		if (vo.getTxtChangeKCode() != null && !vo.getTxtChangeKCode().equals("") ) {
			kCode = vo.getTxtChangeKCode();
		} else if (key1 != null && !key1.equals("")) {
			kCode = key1;
		} else {
			kCode = vo.getTxtKCode();
		}
		// l{擾
		getHumanBasisInfo(kCode, vo);
		// ZbVDTOZbg
		setStoredDto();
	}

	/**
	 * }
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void insert(HumanKihonCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// l{pDAO
		prepareHumanBasisDao();
		// }X^f[^݊mF
		chkDuplicate(mKihonDao.findForKey(vo.getTxtKCode()), vo);
		// o^
		String message = regist(vo);
		// R~bg
		commit();
		// l{擾
		getHumanBasisInfo(vo.getTxtKCode(), vo);
		// bZ[Wݒ
		vo.setMessage(message);
		// ZbVDTOZbg
		setStoredDto();
	}

	/**
	 * XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void update(HumanKihonCardVo vo) throws Exception {
		// ZbVێDTO擾
		getStoredDto();
		// p[^̑ÓmF
		vo.validate();
		// l{pDAO
		prepareHumanBasisDao();
		// o^
		String message = regist(vo);
		// R~bg
		commit();
		// l{擾
		getHumanBasisInfo(vo.getTxtKCode(), vo);
		// bZ[Wݒ
		vo.setMessage(message);
		// ZbVDTOZbg
		setStoredDto();
	}

	/**
	 * v_Eݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void setPulldown(HumanKihonCardVo vo) throws Exception {
		// v_Eݒ
		if (vo.aryPltSectionAll != null) {
			return;
		}
		Date date = util.getSystemDate();
		vo.aryPltOfficeAll		= getOfficeArrayAll();
		vo.aryPltOffice			= getOfficeArray();
		vo.aryPltSectionAll		= getSectionArrayAll();
		vo.aryPltSection		= getSectionArrayForHuman();
		vo.aryPltPositionAll	= getPositionArrayAll();
		vo.aryPltPosition		= getPositionPltArray();
		vo.aryPltRetirement		= util.getRetirementFlagArray();
		vo.aryPltYear			= util.getYearArray(MospUtility.getYear (date), 80, 1);
		vo.aryPltMonth			= util.getMonthArray();
		vo.aryPltDay			= util.getDayArray();
	}

	/**
	 * 擾
	 * @param kCode 擾ΏێЈR[h
	 * @param vo    ݒΏVO
	 * @throws Exception
	 */
	protected void getHumanBasisInfo(String kCode, HumanKihonCardVo vo) throws Exception {
		// l{擾
		findHumanBasisInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKihonDto == null) {
			addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_HUMAN_DATA, ""));
			vo.setTxtChangeKCode(kCode);
			show(vo);
			return;
		}
		// VO
		vo.initFields();
		vo.setTxtChangeKCode(kCode);
		// VOɏݒ
		vo.setFields(mKihonDto);
		vo.setMode(HumanKihonCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmKihonDto = mKihonDto;
		// rݒ
		String editor = setExclusive(CommonConst.EXC_HUMAN_BASIS, user.getUserId(), kCode);
		if (editor != null) {
			addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_EXCLUSIVE, editor));
		}
		setNeedExclusive(true);
	}

	/**
	 * o^
	 * @param vo ΏVO
	 * @return bZ[W
	 * @throws Exception
	 */
	protected String regist(HumanKihonCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DTO
		mKihonDto = storedmKihonDto;
		if (mKihonDto == null) {
			mKihonDto = new MKihonDto();
		}
		vo.setDtoFields(mKihonDto);
		// ݊mF
		String message = "";
		MKihonDto duplicateDto = mKihonDao.findForUpdate(mKihonDto.getKCode());
		if (duplicateDto == null) {
			// VKo^
			mKihonDao.insert(mKihonDto);
			applyHistory(mKihonDto.getKCode(), false, vo);
			message = MospUtility.getMessage(msg, MospConst.MSG_INSERT, "");
		} else {
			// XV
			mKihonDao.update(mKihonDto);
			applyHistory(mKihonDto.getKCode(), true, vo);
			message = MospUtility.getMessage(msg, MospConst.MSG_UPDATE, "");
		}
		return message;
	}

}
